#! /bin/bash

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
NF_DIR=/usr/share/neofetch

echo "Installing neofetch..."
apt update
apt install -y neofetch

echo "Installing scripts..."
mkdir -p $NF_DIR
cp -r $SCRIPT_DIR/* $NF_DIR

echo "Linking script hooks..."
ln -vfs $NF_DIR/motd_hook /etc/profile.d/98-sysinfo.sh
ln -vfs $NF_DIR/update_disk_cache.sh /etc/cron.daily

echo "Generating initial disk cache..."
$NF_DIR/update_disk_cache.sh

echo "Install complete."
